import os from 'os';
import electron from 'electron';

const jsonfile = require('jsonfile');

const baseDir = (electron.remote ? electron.remote : electron).app.getAppPath();
const pkg = jsonfile.readFileSync(`${baseDir}/package.json`);

export const buildNumber = pkg.buildnumber;
export const appVersion =
    pkg.version ||
    (electron.remote ? electron.remote : electron).app.getVersion();

export const osPlatform = `${os.platform()}_${os.arch()}`;

export const OS_IS_MAC = os.platform() === 'darwin';
export const OS_IS_WINDOWS = os.platform() === 'win32';
export const PLATFORM = os.platform();

export const IS_DEBUG =
    process.env.NODE_ENV === 'development' || process.env.DEBUG_PROD === 'true';
